import os
import re

# === PATH FOLDER YANG ADA FILE PHP-NYA ===
base_folder = "app/Views"  # sesuaikan kalau file .php lo ada di folder lain

# === POLA PENGGANTIAN ===
pattern = re.compile(r'\.(jpg|jpeg|png)(?=[\'"])', re.IGNORECASE)

# === LOOP SEMUA FILE PHP ===
for root, dirs, files in os.walk(base_folder):
    for file in files:
        if file.startswith("portfolio_") and file.endswith(".php"):
            file_path = os.path.join(root, file)
            try:
                with open(file_path, 'r', encoding='utf-8') as f:
                    content = f.read()

                new_content = re.sub(pattern, ".webp", content)

                if new_content != content:
                    with open(file_path, 'w', encoding='utf-8') as f:
                        f.write(new_content)
                    print(f"✅ Updated: {file_path}")
                else:
                    print(f"⚪ No change: {file_path}")

            except Exception as e:
                print(f"❌ Error processing {file_path}: {e}")
