import os

# ===== KONFIGURASI =====
base_dir = "public/assets/images"
delete_ext = (".jpg", ".jpeg", ".png")

def delete_old_images():
    print("🧹 Menghapus file gambar lama (.jpg / .jpeg / .png)...\n")

    total_deleted = 0
    for root, _, files in os.walk(base_dir):
        for file in files:
            if file.lower().endswith(delete_ext):
                file_path = os.path.join(root, file)
                try:
                    os.remove(file_path)
                    print(f"✅ Dihapus: {file_path}")
                    total_deleted += 1
                except Exception as e:
                    print(f"❌ Gagal hapus {file_path}: {e}")

    print(f"\n🎯 Selesai! Total file yang dihapus: {total_deleted}")

if __name__ == "__main__":
    delete_old_images()
