import os
from PIL import Image

# ===== KONFIGURASI =====
base_dir = "public/assets/images"  # direktori utama gambar
web_extensions = ('.jpg', '.jpeg', '.png')
webp_quality = 85

def convert_to_webp():
    print("🔄 Mulai konversi gambar ke .webp ...")
    for root, _, files in os.walk(base_dir):
        for file in files:
            if file.lower().endswith(web_extensions):
                old_path = os.path.join(root, file)
                new_path = os.path.splitext(old_path)[0] + ".webp"

                if os.path.exists(new_path):
                    continue  # skip kalau udah dikonversi sebelumnya

                try:
                    img = Image.open(old_path).convert("RGB")
                    img.save(new_path, "webp", quality=webp_quality)
                    print(f"✅ {file} → {os.path.basename(new_path)}")
                except Exception as e:
                    print(f"❌ Gagal convert {file}: {e}")
    print("✅ Semua gambar selesai dikonversi ke .webp\n")


def update_html_php_files():
    print("🔍 Mengupdate referensi file .jpg/.png → .webp di file HTML/PHP ...")

    # file HTML dan PHP yang akan di-scan
    exts = ('.php', '.html', '.htm')
    for root, _, files in os.walk("."):
        for file in files:
            if file.lower().endswith(exts):
                path = os.path.join(root, file)

                with open(path, "r", encoding="utf-8", errors="ignore") as f:
                    content = f.read()

                new_content = content
                for ext in [".jpg", ".jpeg", ".png"]:
                    new_content = new_content.replace(ext, ".webp")

                if new_content != content:
                    with open(path, "w", encoding="utf-8") as f:
                        f.write(new_content)
                    print(f"🧩 Updated: {path}")

    print("✅ Semua referensi gambar sudah diperbarui ke .webp\n")


if __name__ == "__main__":
    convert_to_webp()
    update_html_php_files()
