import os
from PIL import Image, ImageEnhance

# === KONFIGURASI ===
base_folder = "public/assets/images/portfolio"
brightness_factor = 1.25  # 1.0 = normal, 1.25 = 25% lebih terang
webp_quality = 90          # kualitas webp (0-100)
delete_original = False    # True kalau mau hapus jpg/png setelah convert

# === LOOP SEMUA SUBFOLDER DAN FILE ===
for root, dirs, files in os.walk(base_folder):
    for file in files:
        if file.lower().endswith((".jpg", ".jpeg", ".png")):
            file_path = os.path.join(root, file)
            file_name, _ = os.path.splitext(file)
            new_file = os.path.join(root, f"{file_name}.webp")

            try:
                # Buka gambar dan ubah jadi RGB
                img = Image.open(file_path).convert("RGB")

                # Tambah brightness
                enhancer = ImageEnhance.Brightness(img)
                bright_img = enhancer.enhance(brightness_factor)

                # Simpan ke WebP
                bright_img.save(new_file, "webp", quality=webp_quality)

                print(f"✅ Converted: {new_file}")

                # Hapus file asli kalau diaktifkan
                if delete_original:
                    os.remove(file_path)
                    print(f"🗑️ Deleted original: {file_path}")

            except Exception as e:
                print(f"❌ Error processing {file_path}: {e}")
