import os

# Folder utama portfolio
base_folder = "public/assets/images/portfolio"

deleted = 0
skipped = 0

for root, dirs, files in os.walk(base_folder):
    for file in files:
        if file.lower().endswith((".jpg", ".jpeg", ".png")):
            file_path = os.path.join(root, file)
            name, _ = os.path.splitext(file)
            webp_path = os.path.join(root, f"{name}.webp")

            # Hapus hanya kalau ada versi .webp
            if os.path.exists(webp_path):
                try:
                    os.remove(file_path)
                    print(f"🗑️ Deleted old file: {file_path}")
                    deleted += 1
                except Exception as e:
                    print(f"❌ Error deleting {file_path}: {e}")
            else:
                skipped += 1
                print(f"⚪ Skipped (no webp found): {file_path}")

print("\n=== CLEANUP COMPLETE ===")
print(f"Total deleted: {deleted}")
print(f"Skipped: {skipped}")
