<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>

<!-- ===== HERO SECTION ===== -->
<section id="hero-about" class="position-relative text-white">
  <img src="<?= base_url('assets/images/slider/biovisi-Gallery_01.webp') ?>" class="w-100 hero-img" alt="Tentang BIOVISI JAYA UTAMA">
  <div class="hero-overlay"></div>
  <div class="hero-content text-center">
    <h1 class="fw-bold">Tentang <span class="text-orange">BIOVISI JAYA UTAMA</span></h1>
    <p class="lead">Produsen Septic Tank Bio Modern & Ramah Lingkungan</p>
  </div>
</section>

<!-- ===== ABOUT COMPANY ===== -->
<section id="company" class="py-5 bg-light">
  <div class="container">
    <div class="row align-items-center g-5">
      <div class="col-lg-6 text-center">
        <img src="<?= base_url('assets/images/logo/logo.png') ?>" alt="Logo BIOVISI JAYA UTAMA" class="img-fluid p-3" style="max-height: 240px;">
      </div>
      <div class="col-lg-6">
        <h2 class="fw-bold text-primary mb-3">Profil Perusahaan</h2>
        <p class="text-muted mb-3">
          <strong>BIOVISI JAYA UTAMA</strong> adalah perusahaan manufaktur yang berfokus pada produksi 
          <strong>Septic Tank Bio Modern</strong> berbasis teknologi biofilter dan sistem pengolahan limbah ramah lingkungan. 
          Kami menghadirkan solusi sanitasi masa depan yang <strong>praktis, bebas sedot, dan tahan lama</strong>.
        </p>
        <p class="text-muted">
          Dengan komitmen terhadap inovasi dan keberlanjutan, BIOVISI menghadirkan produk septic tank yang 
          mampu menjaga kualitas tanah dan air, serta membantu masyarakat menciptakan lingkungan yang lebih bersih 
          dan sehat.
        </p>
      </div>
    </div>
  </div>
</section>

<!-- ===== VISI & MISI ===== -->
<section id="visi-misi" class="py-5 text-white" style="background:linear-gradient(135deg,#003d7a,#001b40)">
  <div class="container text-center">
    <h2 class="fw-bold mb-5">Visi & Misi</h2>
    <div class="row justify-content-center">
      <div class="col-lg-5 mb-4">
        <div class="p-4 bg-dark bg-opacity-25 rounded-4 shadow-sm h-100">
          <h4 class="fw-bold text-orange mb-3">Visi</h4>
          <p class="mb-0">
            Menjadi pelopor dalam industri sanitasi modern Indonesia dengan menghadirkan 
            produk bioseptik yang ramah lingkungan, efisien, dan berkelanjutan.
          </p>
        </div>
      </div>
      <div class="col-lg-5 mb-4">
        <div class="p-4 bg-dark bg-opacity-25 rounded-4 shadow-sm h-100">
          <h4 class="fw-bold text-orange mb-3">Misi</h4>
          <ul class="text-start">
            <li>Mengembangkan produk bioseptik yang inovatif dan tahan lama.</li>
            <li>Menjaga kualitas lingkungan melalui sistem pengolahan limbah ramah alam.</li>
            <li>Memberikan layanan purna jual cepat dan terpercaya.</li>
            <li>Mengedukasi masyarakat tentang pentingnya sanitasi berkelanjutan.</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ===== CORE VALUES ===== -->
<section id="values" class="py-5 bg-white text-center">
  <div class="container">
    <h2 class="fw-bold text-primary mb-5">Nilai-Nilai BIOVISI</h2>
    <div class="row g-4">
      <div class="col-6 col-lg-3">
        <div class="value-box p-4 rounded-4 shadow-sm h-100 border-top border-3 border-primary">
          <i class="bi bi-recycle fs-1 text-primary mb-3"></i>
          <h5 class="fw-bold">Sustainability</h5>
          <p class="text-muted small">Kami mendukung gaya hidup berkelanjutan melalui teknologi pengolahan limbah biologis.</p>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="value-box p-4 rounded-4 shadow-sm h-100 border-top border-3 border-warning">
          <i class="bi bi-lightbulb-fill fs-1 text-warning mb-3"></i>
          <h5 class="fw-bold">Inovasi</h5>
          <p class="text-muted small">Terus berinovasi menghadirkan septic tank generasi baru yang efisien & praktis.</p>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="value-box p-4 rounded-4 shadow-sm h-100 border-top border-3 border-primary">
          <i class="bi bi-gear-fill fs-1 text-primary mb-3"></i>
          <h5 class="fw-bold">Kualitas</h5>
          <p class="text-muted small">Kami menjaga standar mutu tinggi dalam setiap tahap produksi & pemasangan.</p>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="value-box p-4 rounded-4 shadow-sm h-100 border-top border-3 border-warning">
          <i class="bi bi-heart-fill fs-1 text-orange mb-3"></i>
          <h5 class="fw-bold">Kepedulian</h5>
          <p class="text-muted small">Kami peduli terhadap lingkungan dan kesejahteraan masyarakat sekitar.</p>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ===== CTA SECTION ===== -->
<section id="cta-about" class="py-5 text-center text-white" style="background:linear-gradient(90deg,#ff7a00,#003d7a)">
  <div class="container">
    <h2 class="fw-bold mb-3">Ingin Lingkungan Bersih & Tanpa Bau?</h2>
    <p class="mb-4">Gunakan <strong>Septic Tank BIOVISI</strong> – solusi modern tanpa sedot dan ramah lingkungan.</p>
    <a href="https://wa.me/6281335867408" target="_blank" class="btn btn-light fw-semibold px-4 py-2 rounded-pill">
      <i class="bi bi-whatsapp me-2"></i>Hubungi Kami Sekarang
    </a>
  </div>
</section>

<!-- ===== STYLE ===== -->
<style>
.hero-img {
  height: 70vh;
  object-fit: cover;
  filter: brightness(0.6);
}
.hero-overlay {
  position: absolute;
  inset: 0;
  background: rgba(0,0,0,0.45);
}
.hero-content {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}
.hero-content h1 {
  font-size: 3rem;
  text-shadow: 0 4px 10px rgba(0,0,0,0.4);
}
.text-orange { color: #ff7a00; }

#values .value-box {
  transition: all 0.3s ease;
  border-radius: 12px;
}
#values .value-box:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 20px rgba(0,0,0,0.1);
}
@media (max-width: 768px) {
  .hero-content h1 { font-size: 2rem; }
}
</style>

<?= $this->endSection() ?>
