<?= $this->extend('layouts/main') ?> 
<?= $this->section('content') ?>

<!-- ===== HERO SECTION ===== -->
<section class="produk-hero text-center text-white d-flex align-items-center justify-content-center">
  <div class="overlay"></div>
  <div class="container position-relative z-2">
    <h1 class="fw-bold mb-2 produk-title">KATALOG PRODUK</h1>
    <p class="lead text-white-50 mb-0">VISI JAYA UTAMA | BIO SEPTIC TANK MODERN & PRAKTIS</p>
  </div>
</section>

<!-- ===== PRODUK GRID AUTO FROM FOLDER ===== -->
<section id="produk-list" class="py-5 bg-light">
  <div class="container">
    <h2 class="fw-bold text-primary text-center mb-5">Katalog Produk VISI JAYA UTAMA</h2>
    <div class="row g-4 justify-content-center">
      <?php
        $produkDir = FCPATH . 'assets/images/produk/';
        $produkFiles = glob($produkDir . '*.{jpg,jpeg,png,webp}', GLOB_BRACE);
        $counter = 1;

        if (!empty($produkFiles)):
          foreach ($produkFiles as $file):
            $fileName = basename($file);
            $cleanName = ucwords(str_replace(['-', '_'], ' ', pathinfo($fileName, PATHINFO_FILENAME)));
      ?>
      <div class="col-12 col-md-6 col-lg-4">
        <div class="card produk-card border-0 shadow-sm h-100">
          <div class="produk-img-wrapper" data-bs-toggle="modal" data-bs-target="#produkModal<?= $counter ?>">
            <img src="<?= base_url('assets/images/produk/' . $fileName) ?>" 
                 class="card-img-top" 
                 alt="<?= esc($cleanName) ?>">
          </div>
          <div class="card-body text-center">
            <h5 class="fw-bold text-dark mb-2"><?= esc($cleanName) ?></h5>
            <a href="https://wa.me/6281335867408?text=Halo%20saya%20ingin%20tanya%20produk%20<?= urlencode($cleanName) ?>" 
               class="btn btn-outline-primary rounded-pill btn-sm">
              <i class="bi bi-cart3 me-1"></i> Pesan Sekarang
            </a>
          </div>
        </div>
      </div>

     <!-- ===== MODAL PRODUK (FULL IMAGE) ===== -->
<div class="modal fade" id="produkModal<?= $counter ?>" tabindex="-1" aria-labelledby="produkModalLabel<?= $counter ?>" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content border-0 bg-transparent shadow-none">
      <div class="modal-body p-0 text-center position-relative">
        <button type="button" class="btn-close btn-close-white position-absolute top-0 end-0 m-3" data-bs-dismiss="modal"></button>
        <img src="<?= base_url('assets/images/produk/' . $fileName) ?>" 
             class="img-fluid w-100 rounded-3" 
             alt="<?= esc($cleanName) ?>" 
             style="max-height: 95vh; object-fit: contain; background:#000;">
      </div>
      <div class="modal-footer border-0 d-flex flex-column text-center bg-transparent">
        <h5 class="fw-bold text-white mb-3"><?= esc($cleanName) ?></h5>
        <a href="https://wa.me/6281335867408?text=Halo%20saya%20ingin%20tanya%20produk%20<?= urlencode($cleanName) ?>" 
           class="btn btn-success rounded-pill px-4 fw-semibold">
          <i class="bi bi-whatsapp me-2"></i> Hubungi Kami
        </a>
      </div>
    </div>
  </div>
</div>

      <?php
          $counter++;
          endforeach;
        else:
      ?>
        <div class="col-12 text-center">
          <p class="text-muted">Belum ada produk yang ditambahkan ke katalog.</p>
        </div>
      <?php endif; ?>
    </div>
  </div>
</section>

<!-- ===== CTA ===== -->
<section id="cta-produk" class="py-5 text-white text-center" style="background:linear-gradient(90deg,#004ba0,#012b55)">
  <div class="container">
    <h2 class="fw-bold mb-3">Ingin Dapat Penawaran Terbaik?</h2>
    <p class="mb-4">Konsultasikan kebutuhan produk pipa HDPE Anda bersama tim ahli kami sekarang juga.</p>
    <a href="https://wa.me/6281335867408" class="btn btn-warning fw-semibold px-4 py-2 rounded-pill text-dark">
      <i class="bi bi-whatsapp me-2"></i>Hubungi via WhatsApp
    </a>
  </div>
</section>

<!-- ===== STYLE ===== -->
<style>
/* ===== HERO SECTION ===== */
.produk-hero {
  position: relative;
  height: 30vh;
  background: url('<?= base_url("assets/images/layanan/1.webp") ?>') center/cover no-repeat;
}
.produk-hero .overlay {
  position: absolute;
  inset: 0;
  background: rgba(0,0,0,0.55);
  backdrop-filter: blur(3px);
}

/* ===== GRID ===== */
.produk-card {
  border-radius: 12px;
  overflow: hidden;
  transition: transform .3s ease, box-shadow .3s ease;
  background: #fff;
}
.produk-card img {
  height: 240px;
  width: 100%;
  object-fit: cover;
  transition: transform .3s ease;
}
.produk-img-wrapper {
  cursor: pointer;
  overflow: hidden;
}
.produk-img-wrapper:hover img {
  transform: scale(1.08);
}
.produk-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 22px rgba(0,0,0,0.12);
}

/* ===== MODAL ===== */
.modal-content {
  overflow: hidden;
  border-radius: 18px;
}
.modal-footer {
  border-top: none;
}
.btn-close {
  background-color: #fff;
  border-radius: 50%;
  padding: 8px;
}

/* ===== BUTTON ===== */
.btn-outline-primary {
  border-color: #004ba0;
  color: #004ba0;
}
.btn-outline-primary:hover {
  background: #004ba0;
  color: #fff;
}

/* ===== RESPONSIVE ===== */
@media (max-width: 576px) {
  .produk-hero { height: 25vh; }
  .produk-card img { height: 180px; }
}
</style>

<?= $this->endSection() ?>
