<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>

<!-- ===== HERO SECTION ===== -->
<section class="portfolio-hero text-center text-white d-flex align-items-center justify-content-center">
  <div class="overlay"></div>
  <div class="container position-relative z-2">
    <h1 class="fw-bold display-5 mb-2">Portofolio Klien Menara Sentra</h1>
    <p class="lead text-white-50 mb-0">Kumpulan hasil karya arsitektur, konstruksi, dan desain interior terbaik kami.</p>
  </div>
</section>

<!-- ===== GRID GALLERY SECTION ===== -->
<section class="portfolio-gallery py-5">
  <div class="container-fluid px-0">
    <div class="masonry-grid">

      <?php
        $basePath = FCPATH . 'assets/images/portfolio/';
        $baseUrl  = base_url('assets/images/portfolio/');
        $images = [];

        // Ambil semua gambar dari semua folder klien di portfolio/
        if (is_dir($basePath)) {
          $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($basePath, RecursiveDirectoryIterator::SKIP_DOTS));
          foreach ($rii as $file) {
            if ($file->isFile() && preg_match('/\.(jpe?g|png|webp)$/i', $file->getFilename())) {
              $relativePath = str_replace('\\', '/', str_replace($basePath, '', $file->getPathname()));
              $images[] = $baseUrl . $relativePath;
            }
          }
        }

        // Urutkan berdasarkan nama file
        sort($images);

        if (!empty($images)):
          foreach ($images as $img): ?>
            <div class="gallery-item">
              <img src="<?= esc($img) ?>" alt="Portfolio Image" loading="lazy">
            </div>
          <?php endforeach;
        else: ?>
          <div class="text-center py-5 text-muted">
            <p>Belum ada dokumentasi portfolio.</p>
          </div>
        <?php endif; ?>

    </div>
  </div>
</section>

<!-- ===== STYLE ===== -->
<style>
/* ===== HERO ===== */
.portfolio-hero {
  position: relative;
  height: 42vh;
  background: url('<?= base_url("assets/images/portfolio/cover.webp") ?>') center/cover no-repeat;
}
.portfolio-hero .overlay {
  position: absolute;
  inset: 0;
  background: rgba(0,0,0,0.55);
  backdrop-filter: blur(3px);
}

/* ===== GRID ===== */
.masonry-grid {
  columns: 1;
  column-gap: 0;
  background: #000; /* biar gak ada celah putih */
}

.gallery-item {
  break-inside: avoid;
  margin: 0;
  padding: 0;
  overflow: hidden;
  position: relative;
}

.gallery-item img {
  width: 100%;
  height: auto;
  display: block;
  transition: transform .5s ease, filter .5s ease;
}

.gallery-item:hover img {
  transform: scale(1.05);
  filter: brightness(0.85);
}

/* ===== RESPONSIVE COLUMNS ===== */
@media (min-width: 768px) {
  .masonry-grid {
    columns: 2;
  }
}
@media (min-width: 1200px) {
  .masonry-grid {
    columns: 3;
  }
}

/* ===== MOBILE ===== */
@media (max-width: 768px) {
  .portfolio-hero { height: 30vh; }
  .portfolio-hero h1 { font-size: 1.7rem; }
  .portfolio-hero p { font-size: 0.9rem; }
}
</style>

<?= $this->endSection() ?>
