<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>

<!-- ===== SHOWCASE GRID (Daftar Portfolio Klien) ===== -->
<section id="showcase-grid" class="bg-white py-5">
  <div class="container-fluid px-3 px-md-4">
    <div class="showcase-grid">
      
      <!-- Item -->
      <a href="<?= base_url('portfolio_mpi_bekasi') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/mpi-bekasi-cover.webp') ?>');">
        <div class="photo-label">Project Office & Warehouse MPI Bekasi</div>
      </a>

      <a href="<?= base_url('portfolio_mpi_jakarta') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/mpi-jakarta-headoffice.webp') ?>');">
        <div class="photo-label">Project Head Office & Warehouse PT MPI Jakarta</div>
      </a>

      <a href="<?= base_url('portfolio_mpi_denpasar') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/pembangunan-mpi-denpasar.webp') ?>');">
        <div class="photo-label">Project Warehouse MPI Denpasar</div>
      </a>

      <a href="<?= base_url('portfolio_rs_pusura') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/pembangunan-rs-pusura.webp') ?>');">
        <div class="photo-label">Project Rumah Sakit PUSURA Sidoarjo</div>
      </a>

      <a href="<?= base_url('portfolio_dora_medika') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/cover-dora.webp') ?>');">
        <div class="photo-label">Project Klinik Dora Medika Sidoarjo</div>
      </a>

      <a href="<?= base_url('portfolio_ediansyah_citraland') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/ediansyah-cover.webp') ?>');">
        <div class="photo-label">Kediaman Bp. Ediansyah Citraland - Surabaya</div>
      </a>

      <a href="<?= base_url('portfolio_yuni_kertajaya') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/yuni-kertajaya.webp') ?>');">
        <div class="photo-label">Kediaman Bp.H.Yuni Abdi - Kertajaya indah</div>
      </a>

      <a href="<?= base_url('portfolio_wisma_tropodo') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/wisma-tropodo.webp') ?>');">
        <div class="photo-label">Kediaman Bp. Hamphrey Rusli Wisma Tropodo</div>
      </a>

      <a href="<?= base_url('portfolio_rumah_deltasari') ?>" class="showcase-item" 
         style="background-image: url('<?= base_url('assets/images/cover/harijanto-deltasari.webp') ?>');">
        <div class="photo-label">Kediaman Bp. Harijanto Deltasari</div>
      </a>

    </div>
  </div>
</section>

<style>
/* ===== GRID WRAPPER ===== */
.showcase-grid {
  display: grid;
  grid-template-columns: repeat(1, 1fr);
  gap: 1rem;
  width: 100%;
  margin: 0 auto;
}

/* ===== ITEM ===== */
.showcase-item {
  position: relative;
  display: block;
  background-size: cover;
  background-position: center;
  border-radius: 16px;
  border: 0px solid rgba(255, 215, 0, 0.3);
  aspect-ratio: 4 / 3;
  overflow: hidden;
  text-decoration: none;
  box-shadow: 0 0 10px rgba(255, 215, 0, 0.08);
}

/* ===== LABEL ===== */
.photo-label {
  position: absolute;
  bottom: 10px;
  left: 10px;
  background: rgba(0, 0, 0, 0.85);
  color: #FFD700;
  font-size: 0.9rem;
  font-weight: 700;
  padding: 6px 14px;
  border-radius: 6px;
  border: 1px solid rgba(255, 215, 0, 0.4);
  z-index: 2;
}

/* ===== RESPONSIVE ===== */
@media (min-width: 768px) {
  .showcase-grid {
    grid-template-columns: repeat(2, 1fr);
  }
}

@media (min-width: 992px) {
  .showcase-grid {
    grid-template-columns: repeat(3, 1fr);
  }
}

@media (max-width: 576px) {
  .showcase-item {
    aspect-ratio: 1 / 1;
  }
  .photo-label {
    font-size: 0.75rem;
    padding: 4px 10px;
    bottom: 6px;
    left: 6px;
  }
}
</style>

<!-- ===== CTA BUTTON (PORTFOLIO KAMI) ===== -->


    <div class="text-center my-5">
      <a href="https://wa.me/6281235777379" target="_blank" class="btn btn-gold px-5 py-3 fw-semibold">
        <i class="bi bi-phone"></i> Hubungi MENARA SENTRA
      </a>
    </div>

  </div>
</section>

<style>



/* ===== BUTTON STYLE ===== */
.btn-gold {
  background: linear-gradient(90deg, #d4af37, #f5d76e);
  border: none;
  color: #111;
  border-radius: 50px;
  letter-spacing: 0.5px;
  box-shadow: 0 3px 12px rgba(212,175,55,0.4);
  transition: all 0.3s ease;
}
.btn-gold:hover {
  transform: translateY(-2px);
  box-shadow: 0 6px 18px rgba(212,175,55,0.5);
  color: #000;
}

/* ===== RESPONSIVE ===== */
@media (max-width: 767px) {
  .portfolio-hero { height: 22vh; }
  .portfolio-title { font-size: 1.5rem; }
  .portfolio-subtitle { font-size: 0.9rem; }
  .btn-gold { padding: 0.8rem 2.2rem; font-size: 0.9rem; }
}
</style>

<?= $this->endSection() ?>
