<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>

<!-- ===== HERO SECTION ===== -->
<section class="layanan-hero text-center text-white d-flex align-items-center justify-content-center">
  <div class="overlay"></div>
  <div class="container position-relative z-2">
    <h1 class="fw-bold display-5"><?= esc($title) ?></h1>
    <p class="lead text-white-50 mb-0"><?= esc($desc) ?></p>
  </div>
</section>

<!-- ===== PORTFOLIO GRID ===== -->
<section class="portfolio-grid py-0">
  <div class="container-fluid px-0">
    <div class="row g-1 g-md-2">
      <?php if (!empty($images)): ?>
        <?php foreach ($images as $i => $img): ?>
          <div class="col-12 col-md-6 col-lg-3">
            <a href="#"
               class="gallery-thumb d-block position-relative overflow-hidden"
               data-bs-toggle="modal"
               data-bs-target="#galleryModal"
               data-index="<?= $i ?>">
              <img src="<?= esc($img) ?>" alt="<?= esc($title) ?>" 
                   class="w-100 object-fit-cover" 
                   style="height: 100%; min-height: 260px;">
              <div class="thumb-overlay d-flex align-items-center justify-content-center">
                <i class="bi bi-search text-white fs-2"></i>
              </div>
            </a>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="col-12 text-center py-5">
          <p class="text-muted">Belum ada dokumentasi untuk layanan ini.</p>
        </div>
      <?php endif; ?>
    </div>
  </div>
</section>

<!-- ===== MODAL GALLERY ===== -->
<div class="modal fade" id="galleryModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content bg-black border-0">
      <div class="modal-header border-0">
        <h5 class="modal-title text-white"><?= esc($title) ?></h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body p-0">
        <div class="swiper layananGallerySwiper w-100 h-100">
          <div class="swiper-wrapper">
            <?php foreach ($images as $img): ?>
              <div class="swiper-slide d-flex align-items-center justify-content-center">
                <img src="<?= esc($img) ?>" class="img-fluid object-fit-contain" style="max-height: 100vh;">
              </div>
            <?php endforeach; ?>
          </div>
          <div class="swiper-button-next text-white"></div>
          <div class="swiper-button-prev text-white"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- ===== STYLE ===== -->
<style>
.layanan-hero {
  position: relative;
  height: 45vh;
  background: url('<?= base_url("assets/images/layanan/$slug/cover.webp") ?>') center/cover no-repeat;
}
.layanan-hero .overlay {
  position: absolute;
  inset: 0;
  background: rgba(0,0,0,0.55);
  backdrop-filter: blur(3px);
}

/* ===== GRID ===== */
.portfolio-grid .col-12,
.portfolio-grid .col-md-6,
.portfolio-grid .col-lg-3 {
  padding: 2px;
}
.portfolio-grid img {
  aspect-ratio: 1/1;
  transition: transform .5s ease, filter .5s ease;
}

/* Hover efek */
.gallery-thumb:hover img {
  transform: scale(1.05);
  filter: brightness(0.8);
}
.thumb-overlay {
  position: absolute;
  inset: 0;
  background: rgba(0,0,0,0.3);
  opacity: 0;
  transition: opacity .3s ease;
}
.gallery-thumb:hover .thumb-overlay {
  opacity: 1;
}

/* Modal */
.modal-content { background: #000; }
.swiper-button-next, .swiper-button-prev {
  color: #fff;
  opacity: 0.8;
  transition: opacity 0.3s;
}
.swiper-button-next:hover, .swiper-button-prev:hover { opacity: 1; }

/* ===== RESPONSIVE ===== */
@media (max-width: 768px) {
  .layanan-hero { height: 35vh; }
  .portfolio-grid img {
    aspect-ratio: auto;
    min-height: 220px;
  }
}
</style>

<!-- ===== SCRIPT ===== -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<script>
const gallerySwiper = new Swiper(".layananGallerySwiper", {
  slidesPerView: 1,
  loop: true,
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev"
  },
  keyboard: true
});

document.querySelectorAll('.gallery-thumb').forEach((thumb, index) => {
  thumb.addEventListener('click', () => {
    gallerySwiper.slideToLoop(index, 0);
  });
});
</script>

<?= $this->endSection() ?>
