<?= $this->extend('layouts/main') ?> 
<?= $this->section('content') ?>

<!-- ===== HERO SECTION ===== -->
<section class="layanan-hero text-center text-white d-flex align-items-center justify-content-center">
  <div class="overlay"></div>
  <div class="container position-relative z-2">
    <h1 class="fw-bold mb-2 display-5">Layanan Kami</h1>
    <p class="lead text-white-50 mb-0">Solusi BIO SEPTIC TANK MODERN & PRAKTIS</p>
  </div>
</section>

<!-- ===== LAYANAN UTAMA ===== -->
<section id="layanan-utama" class="py-5 bg-light">
  <div class="container text-center">
    <h2 class="fw-bold text-primary mb-5">Layanan Unggulan Kami</h2>
    <div class="row g-4 justify-content-center">
      <?php 
        $layananList = [
          [
            'icon' => 'bi-pipeline',
            'title' => 'Distribusi Pipa HDPE',
            'desc'  => 'Kami menyediakan berbagai ukuran dan merek pipa HDPE berkualitas tinggi untuk proyek air bersih, industri, dan infrastruktur.'
          ],
          [
            'icon' => 'bi-gear-wide-connected',
            'title' => 'Instalasi Sistem Perpipaan',
            'desc'  => 'Tim profesional kami menangani instalasi pipa HDPE, fitting, dan valve dengan standar keamanan industri.'
          ],
          [
            'icon' => 'bi-wrench-adjustable',
            'title' => 'Maintenance & Repair',
            'desc'  => 'Kami melayani perawatan dan perbaikan sistem perpipaan agar selalu optimal dan bebas gangguan.'
          ],
          [
            'icon' => 'bi-lightbulb',
            'title' => 'Konsultasi Teknis',
            'desc'  => 'Kami membantu Anda memilih produk dan solusi terbaik sesuai kebutuhan proyek dan kondisi lapangan.'
          ],
        ];
        foreach ($layananList as $layanan): ?>
          <div class="col-12 col-md-6 col-lg-3">
            <div class="card layanan-card h-100 border-0 shadow-sm">
              <div class="card-body text-center p-4">
                <div class="icon-wrapper mb-3">
                  <i class="bi <?= $layanan['icon'] ?> fs-1 text-primary"></i>
                </div>
                <h5 class="fw-bold mb-2"><?= esc($layanan['title']) ?></h5>
                <p class="text-muted small"><?= esc($layanan['desc']) ?></p>
              </div>
            </div>
          </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ===== GALERI LAYANAN ===== -->
<section id="galeri-layanan" class="py-5 bg-white">
  <div class="container text-center">
    <h2 class="fw-bold text-primary mb-4">Dokumentasi Layanan Kami</h2>
    <p class="text-muted mb-5">Beberapa dokumentasi hasil pekerjaan dan proyek lapangan VISI JAYA UTAMA.</p>

    <div class="row g-2 g-md-3">
      <?php
        $path = FCPATH . 'assets/images/layanan/';
        $url  = base_url('assets/images/layanan/');
        $images = [];

        if (is_dir($path)) {
          $files = scandir($path);
          foreach ($files as $file) {
            if (preg_match('/\.(jpg|jpeg|png|webp)$/i', $file)) {
              $images[] = $url . $file;
            }
          }
        }
      ?>

      <?php if (!empty($images)): ?>
        <?php foreach ($images as $i => $img): ?>
          <div class="col-12 col-md-4 col-lg-3">
            <a href="#"
               class="gallery-thumb d-block position-relative overflow-hidden rounded-3"
               data-bs-toggle="modal"
               data-bs-target="#galleryModal"
               data-index="<?= $i ?>">
              <img src="<?= esc($img) ?>" alt="Layanan <?= $i+1 ?>" 
                   class="w-100 h-100 object-fit-cover">
              <div class="thumb-overlay d-flex align-items-center justify-content-center">
                <i class="bi bi-search text-white fs-2"></i>
              </div>
            </a>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="col-12 text-center py-5">
          <p class="text-muted">Belum ada foto dokumentasi layanan yang diunggah.</p>
        </div>
      <?php endif; ?>
    </div>
  </div>
</section>

<!-- ===== MODAL GALLERY ===== -->
<div class="modal fade" id="galleryModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content bg-black border-0">
      <div class="modal-header border-0">
        <h5 class="modal-title text-white">Galeri Layanan</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body p-0">
        <div class="swiper gallerySwiper w-100 h-100">
          <div class="swiper-wrapper">
            <?php foreach ($images as $img): ?>
              <div class="swiper-slide d-flex align-items-center justify-content-center">
                <img src="<?= esc($img) ?>" class="img-fluid" style="max-height:100vh; object-fit:contain;">
              </div>
            <?php endforeach; ?>
          </div>
          <div class="swiper-button-next text-white"></div>
          <div class="swiper-button-prev text-white"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- ===== CTA ===== -->
<section id="cta-layanan" class="py-5 text-center text-white" style="background:linear-gradient(90deg,#004ba0,#012b55)">
  <div class="container">
    <h2 class="fw-bold mb-3">Butuh Bantuan Teknis Perpipaan?</h2>
    <p class="mb-4">Hubungi tim kami untuk konsultasi atau kerja sama proyek Anda.</p>
    <a href="https://wa.me/62813358567408" target="_blank" class="btn btn-warning fw-semibold px-4 py-2 rounded-pill text-dark">
      <i class="bi bi-whatsapp me-2"></i>Hubungi VISI JAYA UTAMA
    </a>
  </div>
</section>

<!-- ===== STYLE ===== -->
<style>
/* HERO */
.layanan-hero {
  position: relative;
  height: 35vh;
  background: url('<?= base_url("assets/images/slider/team-visi.webp") ?>') center/cover no-repeat;
}
.layanan-hero .overlay {
  position: absolute; inset: 0;
  background: rgba(0,0,0,0.55);
  backdrop-filter: blur(2px);
}

/* LAYANAN CARD */
.layanan-card {
  border-radius: 14px;
  background: #fff;
  transition: all 0.3s ease;
}
.layanan-card:hover {
  transform: translateY(-6px);
  box-shadow: 0 8px 22px rgba(0,0,0,0.1);
}
.icon-wrapper i {
  background: linear-gradient(90deg,#004ba0,#0b64ff);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}

/* GALERI */
.gallery-thumb {
  border-radius: 8px;
  overflow: hidden;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.gallery-thumb img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  transition: transform .4s ease;
}
.gallery-thumb:hover img {
  transform: scale(1.05);
}
.thumb-overlay {
  position: absolute;
  inset: 0;
  background: rgba(0,0,0,0.3);
  opacity: 0;
  transition: opacity .3s ease;
}
.gallery-thumb:hover .thumb-overlay {
  opacity: 1;
}

/* CTA */
#cta-layanan {
  background: linear-gradient(90deg,#004ba0,#012b55);
}

/* RESPONSIVE */
@media (max-width: 768px) {
  .layanan-hero { height: 25vh; }
  h1.display-5 { font-size: 1.8rem; }
}
</style>

<!-- ===== SWIPER JS ===== -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
const gallerySwiper = new Swiper(".gallerySwiper", {
  slidesPerView: 1,
  loop: true,
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev"
  },
  keyboard: true
});

document.querySelectorAll('.gallery-thumb').forEach((thumb, index) => {
  thumb.addEventListener('click', () => gallerySwiper.slideToLoop(index, 0));
});
</script>

<?= $this->endSection() ?>
