<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>

<!-- ===== MAP SECTION ===== -->
<section class="ratio ratio-16x9">
  <iframe
    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3957.484563760202!2d112.682492!3d-7.298986999999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2dd7e1d93d6b6d6d%3A0x6b567f5e6b65b4f1!2sJl.%20Raya%20Bringin%20Wetan%20No.27%2C%20Beringin%20Bendo%2C%20Taman%2C%20Kabupaten%20Sidoarjo%2C%20Jawa%20Timur%2061257!5e0!3m2!1sid!2sid!4v1730380024355!5m2!1sid!2sid"
    width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy">
  </iframe>
</section>

<!-- ===== CONTACT SECTION ===== -->
<section class="py-5 bg-dark text-center text-white">
  <div class="container" style="max-width:520px;">
    <img src="<?= base_url('assets/images/logo/logovjuputih.webp') ?>" alt="VISI JAYA UTAMA" class="mb-4" style="max-width:160px;">
    <h2 class="fw-bold mb-2">Hubungi VISI JAYA UTAMA</h2>
    <p class="text-white-50 mb-4">Kami siap membantu kebutuhan pipa dan instalasi perpipaan proyek Anda 👇</p>

    <div class="d-flex flex-column gap-3">
      <a href="https://wa.me/62813358567408" target="_blank" class="btn-contact border-blue">
        <i class="bi bi-whatsapp me-2"></i> WhatsApp
      </a>
      <a href="tel:+62813358567408" class="btn-contact border-blue">
        <i class="bi bi-telephone me-2"></i> Telepon
      </a>
      <a href="mailto:info@visijayautama.co.id" class="btn-contact border-blue">
        <i class="bi bi-envelope me-2"></i> Email
      </a>
      <a href="https://goo.gl/maps/1bY6A7JrKfR2" target="_blank" class="btn-contact border-blue">
        <i class="bi bi-geo-alt me-2"></i> Lihat Lokasi Kami
      </a>
    </div>

    <div class="contact-info mt-5 text-white-50 small">
      <p class="mb-1"><i class="bi bi-geo-alt-fill me-2"></i>Jl. Raya Bringin Wetan No.27, Beringin Bendo - Taman - Sidoarjo 61257</p>
      <p class="mb-1"><i class="bi bi-clock me-2"></i>Senin – Sabtu: 08.00 – 17.00</p>
      <p class="mb-0"><i class="bi bi-globe me-2"></i>www.visijayautama.com</p>
    </div>
  </div>
</section>


<!-- ===== FLOATING BUTTON ===== -->
<div class="floating-contact">
  <button class="fab-main" id="fabToggle">
    <i class="bi bi-chat-dots-fill"></i>
  </button>

  <div class="fab-menu" id="fabMenu">
    <a href="tel:+62813358567408" class="fab-item bg-primary text-white" title="Telepon">
      <i class="bi bi-telephone-fill"></i>
    </a>
    <a href="https://wa.me/62813358567408" target="_blank" class="fab-item bg-success text-white" title="WhatsApp">
      <i class="bi bi-whatsapp"></i>
    </a>
    <a href="https://goo.gl/maps/1bY6A7JrKfR2" target="_blank" class="fab-item bg-danger text-white" title="Lokasi">
      <i class="bi bi-geo-alt-fill"></i>
    </a>
  </div>
</div>

<!-- ===== STYLE ===== -->
<style>
/* FLOATING BUTTON CONTAINER */
.floating-contact {
  position: fixed;
  bottom: 24px;
  right: 24px;
  z-index: 9999;
}

/* MAIN BUTTON */
.fab-main {
  width: 58px;
  height: 58px;
  border-radius: 50%;
  background: linear-gradient(135deg, #004ba0, #008cff);
  border: none;
  color: #fff;
  font-size: 1.6rem;
  box-shadow: 0 6px 16px rgba(0,0,0,0.25);
  cursor: pointer;
  transition: all 0.3s ease;
}
.fab-main:hover {
  transform: rotate(15deg) scale(1.05);
  box-shadow: 0 8px 20px rgba(0,0,0,0.35);
}

/* POPUP MENU */
.fab-menu {
  display: flex;
  flex-direction: column;
  align-items: flex-end;
  margin-bottom: 10px;
  opacity: 0;
  visibility: hidden;
  transform: translateY(20px);
  transition: all 0.3s ease;
}
.fab-menu.show {
  opacity: 1;
  visibility: visible;
  transform: translateY(0);
}
.fab-item {
  width: 48px;
  height: 48px;
  margin-bottom: 10px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 1.25rem;
  text-decoration: none;
  box-shadow: 0 4px 10px rgba(0,0,0,0.2);
  transition: all 0.3s ease;
}
.fab-item:hover {
  transform: translateY(-3px) scale(1.1);
}
</style>

<!-- ===== SCRIPT ===== -->
<script>
document.getElementById('fabToggle').addEventListener('click', function() {
  document.getElementById('fabMenu').classList.toggle('show');
});
</script>


<!-- ===== STYLE ===== -->
<style>
/* ===== BACKGROUND ===== */
.bg-dark {
  background: linear-gradient(180deg, #002f6c 0%, #001d3d 100%);
}

/* ===== BUTTON ===== */
.btn-contact {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  font-weight: 600;
  font-size: 1.05rem;
  border-radius: 50px;
  padding: 0.9rem 1.5rem;
  text-decoration: none;
  color: #fff;
  background: transparent;
  transition: all 0.3s ease;
  width: 100%;
  border: 2px solid transparent;
  letter-spacing: 0.5px;
}

.border-blue {
  border-color: #007bff;
}

.border-blue:hover {
  background: linear-gradient(90deg, #007bff, #00c6ff);
  color: #fff;
  box-shadow: 0 0 20px rgba(0, 150, 255, 0.4);
  transform: translateY(-3px);
}

/* ===== ICON ===== */
.btn-contact i {
  font-size: 1.3rem;
}

/* ===== INFO ===== */
.contact-info {
  margin-top: 40px;
  border-top: 1px solid rgba(255,255,255,0.2);
  padding-top: 15px;
}
.contact-info i {
  color: #00bfff;
}

/* ===== RESPONSIVE ===== */
@media (max-width: 768px) {
  .btn-contact { font-size: 1rem; padding: 0.8rem 1.2rem; }
  h2 { font-size: 1.6rem; }
}
</style>



<?= $this->endSection() ?>
