<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>

<!-- ===== HERO SLIDER (AUTO FOLDER & JSON) ===== -->
<section id="hero-slider" class="position-relative">
  <div id="carouselHero" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="4500">
    <div class="carousel-inner">
      <?php
        $sliderDir = FCPATH . 'assets/images/slider/';
        $sliderJson = $sliderDir . 'slider.json';
        $images = glob($sliderDir . '*.{jpg,jpeg,png,webp}', GLOB_BRACE);

        $texts = [];
        if (file_exists($sliderJson)) {
          $decoded = json_decode(file_get_contents($sliderJson), true);
          if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
            $texts = $decoded;
          }
        }

        if (!empty($images)):
          foreach ($images as $i => $imgPath):
            $isActive = $i === 0 ? 'active' : '';
            $title = $texts[$i]['title'] ?? 'BIOVISI JAYA UTAMA';
            $desc  = $texts[$i]['desc'] ?? 'Produsen Septic Tank Modern dan Ramah Lingkungan';
            $fileName = basename($imgPath);
      ?>
        <div class="carousel-item <?= $isActive ?>">
          <img src="<?= base_url('assets/images/slider/' . $fileName) ?>" class="d-block w-100 hero-img" alt="Slide <?= $i+1 ?>">
          <div class="carousel-caption text-start d-none d-md-block">
            <h2 class="fw-bold"><?= esc($title) ?></h2>
            <p><?= esc($desc) ?></p>
          </div>
        </div>
      <?php endforeach; else: ?>
        <div class="carousel-item active">
          <img src="<?= base_url('assets/images/no-image.webp') ?>" class="d-block w-100 hero-img" alt="No Image">
          <div class="carousel-caption d-none d-md-block">
            <h2 class="fw-bold">BIOVISI JAYA UTAMA</h2>
            <p>Produsen Septic Tank Modern dan Praktis — Solusi Lingkungan Bersih & Efisien</p>
          </div>
        </div>
      <?php endif; ?>
    </div>

    <button class="carousel-control-prev" type="button" data-bs-target="#carouselHero" data-bs-slide="prev">
      <span class="carousel-control-prev-icon"></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#carouselHero" data-bs-slide="next">
      <span class="carousel-control-next-icon"></span>
    </button>
  </div>
</section>

<!-- ===== ABOUT ===== -->
<section id="about" class="py-5 bg-dark text-white">
  <div class="container">
    <div class="row align-items-center g-5">
      <div class="col-lg-6">
        <h2 class="fw-bold text-orange mb-3">Tentang BIOVISI JAYA UTAMA</h2>
        <p class="mb-4 text-white-50">
          <strong>BIOVISI</strong> adalah produsen <strong>Septic Tank Bio Modern</strong> 
          yang dirancang untuk ramah lingkungan, efisien, dan tahan lama. 
          Kami menghadirkan solusi sanitasi masa depan dengan sistem bioteknologi 
          tanpa bau, tanpa sedot, dan mudah dipasang untuk rumah, villa, hingga proyek besar.
        </p>
        <a href="<?= base_url('produk') ?>" class="btn btn-outline-warning fw-semibold px-4 rounded-pill">
          <i class="bi bi-box-seam me-2"></i> Lihat Produk Kami
        </a>
      </div>
      <div class="col-lg-6 text-center">
        <img src="<?= base_url('assets/images/logo/logoputih.png') ?>" alt="Logo BIOVISI" class="img-fluid" style="max-height: 220px;">
      </div>
    </div>
  </div>
</section>

<!-- ===== PRODUK SECTION ===== -->
<section id="produk" class="py-5 bg-light">
  <div class="container text-center">
    <h2 class="fw-bold text-primary mb-5">Produk & Keunggulan BIOVISI</h2>
    <div class="row g-4">
      <?php
        $produk = [
          ['img' => '1.webp', 'title' => 'BIOVISI Septic Tank Modern', 'desc' => 'Menggunakan sistem biofilter 3 lapis untuk penguraian limbah yang maksimal.'],
          ['img' => '2.webp', 'title' => 'Instalasi Mudah', 'desc' => 'Desain compact siap pasang, cocok untuk area perumahan dan proyek.'],
          ['img' => '3.webp', 'title' => 'Anti Bau & Ramah Lingkungan', 'desc' => 'Mengurangi pencemaran tanah dan air dengan teknologi oksidasi biologis.'],
        ];
        foreach ($produk as $p): ?>
          <div class="col-12 col-md-6 col-lg-4">
            <div class="card produk-card border-0 shadow-sm h-100">
              <img src="<?= base_url('assets/images/produk/' . $p['img']) ?>" class="card-img-top" alt="<?= esc($p['title']) ?>">
              <div class="card-body">
                <h5 class="fw-bold text-dark"><?= esc($p['title']) ?></h5>
                <p class="text-muted small mb-3"><?= esc($p['desc']) ?></p>
              </div>
            </div>
          </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ===== PORTFOLIO ===== -->
<section id="portfolio" class="py-5 bg-black text-center text-white">
  <div class="container">
    <h2 class="fw-bold text-orange mb-4">Galeri Pemasangan & Proyek</h2>
    <div class="swiper portfolio-swiper">
      <div class="swiper-wrapper">
        <?php
          $projectDir = FCPATH . 'assets/images/proyek/';
          $projectImgs = glob($projectDir . '*.{jpg,jpeg,png,webp}', GLOB_BRACE);
          if (!empty($projectImgs)):
            foreach ($projectImgs as $p):
              $file = basename($p);
        ?>
          <div class="swiper-slide">
            <img src="<?= base_url('assets/images/proyek/' . $file) ?>" class="portfolio-img rounded shadow-sm" alt="Proyek BIOVISI">
          </div>
        <?php endforeach; else: ?>
          <div class="swiper-slide"><img src="<?= base_url('assets/images/no-image.webp') ?>" class="portfolio-img rounded shadow-sm"></div>
        <?php endif; ?>
      </div>
      <div class="swiper-pagination mt-3"></div>
      <div class="swiper-button-prev"></div>
      <div class="swiper-button-next"></div>
    </div>
  </div>
</section>

<!-- ===== CTA ===== -->
<section id="cta" class="py-5 text-center text-white" style="background:linear-gradient(90deg,#ff7a00,#111)">
  <div class="container">
    <h2 class="fw-bold mb-3">Ingin Punya Septic Tank Modern & Ramah Lingkungan?</h2>
    <p class="mb-4">Hubungi tim BIOVISI sekarang untuk konsultasi dan pemesanan.</p>
    <a href="https://wa.me/6281335867408" class="btn btn-warning text-dark fw-semibold px-4 py-2 rounded-pill">
      <i class="bi bi-whatsapp me-2"></i>Hubungi Kami
    </a>
  </div>
</section>

<!-- ===== STYLE ===== -->
<style>
.hero-img { height: 85vh; object-fit: cover; filter: brightness(0.7); }
.carousel-caption { position: absolute; bottom: 14%; left: 8%; right: 8%; }
.carousel-caption h2 {
  font-size: 2.4rem;
  color: #fff;
  background: rgba(0,0,0,0.4);
  display: inline-block;
  padding: .5rem 1rem;
  border-left: 5px solid #ff7a00;
}
.carousel-caption p { color: #f0f0f0; max-width: 600px; font-size: 1.1rem; }

.text-orange { color: #ff7a00 !important; }

.produk-card img { height: 220px; object-fit: cover; transition: transform .3s; }
.produk-card:hover img { transform: scale(1.05); }

.portfolio-img { height: 260px; width: 100%; object-fit: cover; transition: transform .3s ease; }
.portfolio-img:hover { transform: scale(1.05); }

.swiper-pagination-bullet-active { background: #ff7a00; }
.swiper-button-prev, .swiper-button-next { color: #ff7a00; }
</style>

<!-- ===== SWIPER JS ===== -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css"/>
<script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>
<script>
new Swiper('.portfolio-swiper', {
  slidesPerView: 1,
  spaceBetween: 20,
  loop: true,
  autoplay: { delay: 2800, disableOnInteraction: false },
  pagination: { el: '.swiper-pagination', clickable: true },
  navigation: { nextEl: '.swiper-button-next', prevEl: '.swiper-button-prev' },
  breakpoints: { 768: { slidesPerView: 2 }, 992: { slidesPerView: 3 } }
});
</script>

<?= $this->endSection() ?>
