<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- ===== TITLE & BASIC META ===== -->
  <title><?= esc($title ?? 'VISI JAYA UTAMA | Distributor Pipa HDPE & Jasa Instalasi Perpipaan Sidoarjo') ?></title>
  <meta name="description" content="<?= esc($desc ?? 'VISI JAYA UTAMA adalah distributor resmi pipa HDPE dan penyedia jasa instalasi perpipaan profesional di Sidoarjo, dengan pengalaman proyek industri, perumahan, dan pemerintahan.') ?>">
  <meta name="keywords" content="distributor pipa HDPE, jasa instalasi pipa, kontraktor pipa air, fitting HDPE, pipa air bersih, supplier pipa Sidoarjo, instalasi pipa proyek, pipa air tanah, pipa irigasi, pipa Rucika, pipa Wavin">
  <meta name="author" content="VISI JAYA UTAMA">

  <!-- ===== FAVICON ===== -->
  <link rel="icon" type="image/png" href="<?= base_url('assets/images/logo/favicon.webp') ?>">

  <!-- ===== OPEN GRAPH ===== -->
  <meta property="og:title" content="<?= esc($title ?? 'VISI JAYA UTAMA | Distributor Pipa HDPE & Instalasi Pipa Sidoarjo') ?>">
  <meta property="og:description" content="<?= esc($desc ?? 'Pusat distribusi pipa HDPE dan jasa pemasangan perpipaan terpercaya untuk kebutuhan proyek dan industri di Sidoarjo.') ?>">
  <meta property="og:image" content="<?= base_url('assets/images/logo/logo.webp') ?>">
  <meta property="og:url" content="<?= current_url() ?>">
  <meta property="og:type" content="website">
  <meta property="og:site_name" content="VISI JAYA UTAMA">

  <!-- ===== TWITTER CARD ===== -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="VISI JAYA UTAMA – Distributor Pipa HDPE Sidoarjo">
  <meta name="twitter:description" content="Ahli distribusi dan instalasi pipa HDPE dengan kualitas terbaik dan layanan profesional.">
  <meta name="twitter:image" content="<?= base_url('assets/images/logo.webp') ?>">

  <link rel="canonical" href="<?= current_url() ?>">
  <meta http-equiv="Content-Language" content="id-ID">

  <!-- ===== STRUCTURED DATA SCHEMA ===== -->
  <script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "name": "VISI JAYA UTAMA",
    "image": "<?= base_url('assets/images/logo.webp') ?>",
    "description": "Distributor pipa HDPE dan penyedia jasa instalasi perpipaan profesional di Sidoarjo.",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "Jl. Raya Bringin Wetan No. 27, Beringin Bendo - Taman - Sidoarjo",
      "addressLocality": "Sidoarjo",
      "addressRegion": "Jawa Timur",
      "postalCode": "61257",
      "addressCountry": "ID"
    },
    "telephone": "+6281335867408",
    "url": "https://visijayautama.com",
    "priceRange": "$$",
    "openingHours": "Mo-Fr 08:00-17:00",
    "sameAs": [
      "https://www.instagram.com/visijayautama",
      "https://www.facebook.com/visijayautama",
      "https://www.linkedin.com/company/visijayautama"
    ]
  }
  </script>

  <!-- Bootstrap & Fonts -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

  <style>
    :root {
      --vj-primary: #004ba0; /* biru industrial */
      --vj-accent: #ff7a00; /* oranye khas Rucika/Wavin */
      --vj-dark: #012b55;
    }

    body { font-family: 'Inter', sans-serif; }

    /* Navbar */
    .navbar-blur {
      position: fixed;
      top: 0; left: 0;
      width: 100%; z-index: 1000;
      background: rgba(255,255,255,0.15);
      backdrop-filter: blur(10px);
      transition: background .3s ease, box-shadow .3s ease;
    }
    .navbar-blur.scrolled {
      background: rgba(255,255,255,0.98);
      box-shadow: 0 4px 20px rgba(0,0,0,0.05);
    }
    .navbar-nav .nav-link {
      color: var(--vj-dark);
      font-weight: 600;
    }
    .navbar-nav .nav-link:hover {
      color: var(--vj-accent);
    }
    main { margin-top: 85px; }

    /* Footer */
    .footer-modern {
      background: radial-gradient(var(--vj-dark) 0%, #001a33 100%);
      color: #fff;
    }
    .footer-modern h6 {
      color: var(--vj-accent);
      font-weight: 700;
      text-transform: uppercase;
    }
    .footer-link {
      color: #fff;
      text-decoration: none;
      display: block;
      margin-bottom: .4rem;
      transition: color .3s;
    }
    .footer-link:hover { color: var(--vj-accent); }
    .social-icon {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 38px; height: 38px;
      background: rgba(255,255,255,0.1);
      border-radius: 50%;
      color: #fff;
      margin-right: 10px;
      transition: .3s;
    }
    .social-icon:hover {
      background: var(--vj-accent);
      color: #fff;
      transform: translateY(-3px);
    }
  </style>
</head>

<body>

<!-- ===== LOGO MOBILE ===== -->
<div class="mobile-logo d-lg-none position-fixed top-0 start-50 translate-middle-x mt-3">
  <a href="<?= base_url('/') ?>" class="d-flex align-items-center justify-content-center bg-white bg-opacity-75 rounded-pill shadow-sm px-3 py-2 text-decoration-none">
    <img src="<?= base_url('assets/images/logo/logo.webp') ?>" alt="VISI JAYA UTAMA" style="height:12px;">
  </a>
</div>

<header>
  <nav id="navbarMain" class="navbar navbar-expand-lg navbar-blur py-3">
    <div class="container align-items-center">
      <a class="navbar-brand fw-semibold d-flex align-items-center" href="<?= base_url('/') ?>">
        <img src="<?= base_url('assets/images/logo/logo.png') ?>" alt="VISI JAYA UTAMA" style="height:45px;">
      </a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMain">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse justify-content-center" id="navMain">
        <ul class="navbar-nav gap-lg-4 fw-medium align-items-center">
          <li class="nav-item"><a class="nav-link" href="<?= base_url('/') ?>">Home</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= base_url('produk') ?>">Produk</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= base_url('layanan') ?>">Layanan</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= base_url('tentang') ?>">Tentang Kami</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= base_url('kontak') ?>">Kontak</a></li>
        </ul>
      </div>

      <div class="d-none d-lg-flex align-items-center ms-3 gap-3">
        <a href="<?= base_url('kontak') ?>" class="btn fw-semibold px-3 py-2 text-white" style="background:var(--vj-accent);border-radius:8px;">
          Hubungi Kami
        </a>
      </div>
    </div>
  </nav>
</header>

<main>
  <?= $this->renderSection('content') ?>
</main>



<!-- ===== FOOTER ===== -->
<footer class="footer-modern text-light pt-5 pb-4 mt-5">
  <div class="container">
    <div class="row gy-4">
      <div class="col-md-4">
        <a href="<?= base_url('/') ?>" class="d-inline-flex align-items-center mb-3 text-decoration-none">
          <img src="<?= base_url('assets/images/logo/putihfooter.png') ?>" alt="VISI JAYA UTAMA" style="height:60px;">
        </a>
        <p class="small text-white-50">
          VISI JAYA UTAMA adalah distributor BIOVISI Septic Tank Modern dan Ramah Lingkungan di Sidoarjo.
        </p>
      </div>

      <div class="col-md-4">
        <h6 class="fw-bold text-uppercase mb-3">Navigasi</h6>
        <ul class="list-unstyled mb-0">
          <li><a href="<?= base_url('produk') ?>" class="footer-link">Produk Kami</a></li>
          <li><a href="<?= base_url('layanan') ?>" class="footer-link">Jasa Instalasi</a></li>
          <li><a href="<?= base_url('tentang') ?>" class="footer-link">Tentang Kami</a></li>
          <li><a href="<?= base_url('kontak') ?>" class="footer-link">Kontak</a></li>
        </ul>
      </div>

      <div class="col-md-4">
        <h6 class="fw-bold text-uppercase mb-3">Kantor Kami</h6>
        <p class="small mb-2">Jl. Raya Bringin Wetan No. 27, Beringin Bendo - Taman - Sidoarjo 61257</p>
        <p class="small mb-3">Telp: <a href="tel:+6281335867408" class="text-white text-decoration-none">0813-3586-7408</a></p>
        <a href="https://instagram.com/visijayautama" class="social-icon"><i class="bi bi-instagram"></i></a>
        <a href="https://www.linkedin.com/company/visijayautama" class="social-icon"><i class="bi bi-linkedin"></i></a>
      </div>
    </div>

    <hr class="border-light opacity-25 my-4">
    <div class="text-center small text-white-50">
      © <?= date('Y') ?> <strong>VISI JAYA UTAMA</strong>. All rights reserved.
    </div>
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  document.addEventListener('scroll', () => {
    const nav = document.getElementById('navbarMain');
    nav.classList.toggle('scrolled', window.scrollY > 50);
  });
</script>
</body>
</html>
