<?php

namespace App\Controllers;
use CodeIgniter\Controller;

class Home extends Controller
{
    /* ===== HALAMAN UTAMA ===== */
    public function index()
    {
        return view('pages/home', [
            'title' => 'VISI JAYA UTAMA – Distributor Pipa HDPE Sidoarjo, Jasa Instalasi Perpipaan Terpercaya',
            'page'  => 'home'
        ]);
    }

    /* ===== PORTFOLIO ===== */
    public function portfolio()
    {
        return view('pages/portfolio', [
            'title' => 'Portofolio Klien',
            'page'  => 'portfolio'
        ]);
    }

    public function portfolioDetail($slug)
    {
        $folderPath = FCPATH . 'assets/images/portfolio/' . $slug;

        if (!is_dir($folderPath)) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Project not found: $slug");
        }

        $images = glob($folderPath . '/*.{jpg,jpeg,png,webp}', GLOB_BRACE);

        $infoPath = $folderPath . '/info.json';
        $info = file_exists($infoPath)
            ? json_decode(file_get_contents($infoPath), true)
            : ['title' => ucfirst(str_replace('-', ' ', $slug)), 'category' => 'Project'];

        return view('pages/portfolio_all', [
            'title'   => $info['title'],
            'page'    => 'portfolio',
            'slug'    => $slug,
            'images'  => $images,
            'info'    => $info
        ]);
    }

    /* ===== LAYANAN ===== */
    public function layanan()
    {
        return view('pages/layanan', [
            'title' => 'Layanan Menara Sentra',
            'page'  => 'layanan'
        ]);
    }

    public function layananDetail($slug)
    {
        // Lokasi folder gambar
        $folderPath = FCPATH . 'assets/images/layanan/' . $slug . '/';
        $webBase = base_url('assets/images/layanan/' . $slug . '/');

        if (!is_dir($folderPath)) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Layanan tidak ditemukan: $slug");
        }

        // Ambil semua gambar di folder (fix path pakai trailing slash)
        $images = glob($folderPath . '*.{jpg,jpeg,png,webp,JPG,JPEG,PNG,WEBP}', GLOB_BRACE);
        $images = array_map(fn($img) => $webBase . basename($img), $images); // ubah ke URL web

        // Ambil info.json kalau ada
        $infoPath = $folderPath . 'info.json';
        $info = file_exists($infoPath)
            ? json_decode(file_get_contents($infoPath), true)
            : [
                'title' => ucfirst(str_replace('-', ' ', $slug)),
                'desc'  => 'Deskripsi layanan akan segera tersedia.'
            ];

        return view('pages/layanan_detail', [
            'title'  => $info['title'],
            'page'   => 'layanan',
            'slug'   => $slug,
            'desc'   => $info['desc'],
            'images' => $images
        ]);
    }

    

public function artikel()
{
    $folder = FCPATH . 'assets/artikel/';
    $files  = glob($folder . '*.json');
    $artikelList = [];

    foreach ($files as $file) {
        $data = json_decode(file_get_contents($file), true);
        $slug = basename($file, '.json');

        $artikelList[] = [
            'slug'        => $slug,
            'title'       => $data['title'] ?? ucfirst(str_replace('-', ' ', $slug)),
            'description' => $data['description'] ?? '',
            'image'       => base_url($data['image'] ?? 'assets/images/depan/hero.webp')
        ];
    }

    // Urutkan berdasarkan nama file (optional)
    usort($artikelList, fn($a, $b) => strcmp($a['title'], $b['title']));

    return view('artikel_index', [
        'title'   => 'Artikel & Insight | Menara Sentra',
        'artikel' => $artikelList
    ]);
}


    /* ===== KONTAK ===== */
    public function kontak()
    {
        return view('pages/kontak', [
            'title' => 'Kontak Menara Sentra',
            'page'  => 'kontak'
        ]);
    }
}


