<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// ===== DEFAULT =====
$routes->get('/', 'Home::index');


$routes->get('artikel', 'Home::artikel'); // daftar semua
$routes->get('artikel/(:segment)', 'Home::artikel/$1'); // halaman per artikel


// ===== STATIC PAGES =====
$routes->get('layanan', 'Home::layanan');
$routes->get('layanan/(:segment)', 'Home::layananDetail/$1');
$routes->get('portfolio', 'Home::portfolio');
$routes->get('portfolio-all', 'Home::portfolio_all');

$routes->get('artikel', 'Home::artikel'); // daftar semua
$routes->get('artikel/(:segment)', 'Home::artikel/$1'); // halaman per artikel


$routes->get('kontak', 'Home::kontak');

// ===== PORTFOLIO SPESIFIK (harus sebelum yang dinamis) =====
$routes->get('portfolio/mpi-jakarta', 'Home::portfolioMpiJakarta');
$routes->get('portfolio/mpi-bekasi', 'Home::portfolioMpiBekasi');
$routes->get('portfolio/mpi-denpasar', 'Home::portfolioMpiDenpasar');
$routes->get('portfolio/mpi-surabaya', 'Home::portfolioMpiSurabaya');
$routes->get('portfolio/ediansyah-citraland', 'Home::portfolioEdiansyahCitraland');
$routes->get('portfolio/yuni-kertajaya', 'Home::portfolioYuniKertajaya');
$routes->get('portfolio/dora-medika', 'Home::portfolioDoraMedika');
$routes->get('portfolio/rs-pusura', 'Home::portfolioRsPusura');
$routes->get('portfolio/sekolah-indriyasana', 'Home::portfolioSekolahIndriyasana');
$routes->get('portfolio/wisma-tropodo', 'Home::portfolioWismaTropodo');
$routes->get('portfolio/rumah-deltasari', 'Home::portfolioRumahDeltasari');

// ===== DYNAMIC PORTFOLIO DETAIL (fallback terakhir) =====
$routes->get('portfolio/(:segment)', 'Home::portfolioDetail/$1');

// ===== DYNAMIC PAGE FALLBACK =====
$routes->get('(:segment)', function ($page) {
    $filePath = APPPATH . 'Views/pages/' . $page . '.php';
    if (is_file($filePath)) {
        return view('pages/' . $page, [
            'title' => ucfirst($page),
            'page'  => $page
        ]);
    }
    throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Halaman tidak ditemukan: " . $page);
});

// ===== 404 OVERRIDE =====
$routes->set404Override(function () {
    return view('errors/html/error_404', [
        'title' => 'Halaman Tidak Ditemukan'
    ]);
});

// ===== SECURITY =====
// ⚠️ Matikan AutoRoute biar gak ada akses controller liar
$routes->setAutoRoute(false);
